// priority: 6
let 重生保护_最大追踪分钟数;
let 重生保护移除配置 = {
    启用: true,
    半径: 128,
    仅限敌对: true,
    通知全服: true,
    无清除时是否通知玩家: true,
    排除ID: [
        "minecraft:ender_dragon", // 末影龙
        "minecraft:wither", // 凋灵
        "minecraft:elder_guardian", // 远古守卫者
        "goety:apostle", // 使徒
        "cataclysm:ignis", // 焰魔
        "alexsmobs:void_worm", // 虚空蠕虫
        "goety:wight", // 孤魂尸鬼
        "goety:inferno", // 狱焰
        "goety:crone", // 巫婆
        "twilightforest:alpha_yeti", // 雪怪首领
        "twilightforest:hydra", // 九头蛇
        "twilightforest:knight_phantom", // 幻影骑士
        "twilightforest:lich", // 巫妖 
        "twilightforest:minoshroom", // 米诺菇
        "twilightforest:naga", // 娜迦
        "twilightforest:snow_queen", // 冰雪女王
        "twilightforest:ur_ghast", // 暮初恶魂
        "irons_spellbooks:dead_king", // 死者之王
        "bosses_of_mass_destruction:void_blossom", // 虚空之花
        "cataclysm:kobolediator", // 骷髅狗头人将军
        "minecraft:warden", // 监守者
        "graveyard:lich", // 墓园巫妖
        "illagerinvasion:invoker", // 祈灵师
        "goety:skull_lord", // 骷髅领主
        "goety:bone_lord", // 骨骼领主
        "goety:wither_necromancer", // 凋零死灵法师
        "mowziesmobs:ferrous_wroughtnaut", // 钢铁守护者
        "mowziesmobs:umvuthi", // 太阳鸟
        "bosses_of_mass_destruction:lich", // 暗夜巫妖
        "mowziesmobs:frostmaw", // 霜冻巨兽
        "aquamirae:maze_mother", // 迷宫之母
        "aquamirae:captain_cornelia", // 船长科妮莉亚亡灵
        "cataclysm:ender_guardian", // 末影守卫者
        "cataclysm:netherite_monstrosity", // 下界合金巨兽
        "cataclysm:the_harbinger", // 先驱者
        "cataclysm:the_leviathan", // 利维坦
        "cataclysm:ancient_remnant", // 远古遗魂
        "cataclysm:maledictus", // 咒翼灵骸
        "goety:vizier", // 宰相
        "goety:vizier_clone", // 宰相之影
        "bosses_of_mass_destruction:obsidilith" // 黑曜石柱
    ],
    排除标签: [

    ],
    排除自定义名称: [ // 通过命名牌命名的
        "重要",
        "命名牌"
    ],
    启用死亡频率检测: true,
    死亡频率触发条件: [
        { 时间范围分钟: 1, 次数: 3, 描述: "1分钟内死亡3次" },
        { 时间范围分钟: 3, 次数: 5, 描述: "3分钟内死亡5次" },
        { 时间范围分钟: 5, 次数: 8, 描述: "5分钟内死亡8次" },
    ],
};

(function () {
    if (typeof 重生保护_最大追踪分钟数 === "undefined") {
        let 最大分钟数 = 0;
        if (重生保护移除配置.启用死亡频率检测 && 重生保护移除配置.死亡频率触发条件.length > 0) {
            let 各条件时间范围 = 重生保护移除配置.死亡频率触发条件.map(c => c.时间范围分钟);
            if (各条件时间范围.length > 0) {
                最大分钟数 = Math.max.apply(null, 各条件时间范围);
            }
        }
        重生保护_最大追踪分钟数 = 最大分钟数;
        重生保护_最大追踪分钟数 = true;
    }
})();

PlayerEvents.respawned(e => {
    if (!重生保护移除配置.启用) {
        return;
    }

    let p = e.player;
    if (!p || !p.level) {
        return;
    }

    let 当前时间戳 = Date.now();
    let 是否执行移除 = !重生保护移除配置.启用死亡频率检测;

    if (重生保护移除配置.启用死亡频率检测) {
        let 本次死亡时间记录 = [];

        if (p.persistentData.contains("重生保护_死亡时间戳列表")) {
            let 原始数据 = p.persistentData.重生保护_死亡时间戳列表;
            if (原始数据 && typeof 原始数据.size === "function" && typeof 原始数据.get === "function") {
                for (let 索引 = 0; 索引 < 原始数据.size(); 索引++) {
                    let NBT值 = 原始数据.get(索引);
                    if (typeof NBT值 === "number") {
                        本次死亡时间记录.push(NBT值);
                    } else if (NBT值 && typeof NBT值.asLong === "function") {
                        本次死亡时间记录.push(NBT值.asLong());
                    } else if (NBT值 && typeof NBT值.getAsNumber === "function") {
                        本次死亡时间记录.push(NBT值.getAsNumber());
                    } else if (NBT值 && typeof NBT值.longValue === "function") {
                        本次死亡时间记录.push(Number(NBT值.longValue()));
                    } else if (NBT值 && NBT值.toString) {
                        let num = Number(NBT值.toString());
                        if (!isNaN(num)) {
                            本次死亡时间记录.push(num);
                        }
                    }
                }
            } else if (Array.isArray(原始数据)) {
                本次死亡时间记录 = 原始数据.filter(item => typeof item === "number");
            }
        }

        本次死亡时间记录.push(当前时间戳);
        p.persistentData.重生保护_死亡时间戳列表 = 本次死亡时间记录;

        if (重生保护_最大追踪分钟数 > 0) {
            let 全局截止时间 = 当前时间戳 - (重生保护_最大追踪分钟数 * 60 * 1000);
            let 过滤后时间戳列表 = 本次死亡时间记录.filter(时间戳 => 时间戳 >= 全局截止时间);
            p.persistentData.重生保护_死亡时间戳列表 = 过滤后时间戳列表;
            本次死亡时间记录 = 过滤后时间戳列表;
        }

        for (let 条件 of 重生保护移除配置.死亡频率触发条件) {
            let 条件时间窗口毫秒 = 条件.时间范围分钟 * 60 * 1000;
            let 条件截止时间 = 当前时间戳 - 条件时间窗口毫秒;
            let 时间窗口内死亡次数 = 本次死亡时间记录.filter(死亡时间 => 死亡时间 >= 条件截止时间).length;

            if (时间窗口内死亡次数 >= 条件.次数) {
                是否执行移除 = true;
                p.persistentData.重生保护_死亡时间戳列表 = [];
                break;
            }
        }
    }

    if (!是否执行移除) {
        if (重生保护移除配置.无清除时是否通知玩家) {
             if (重生保护移除配置.启用死亡频率检测) {
             } else {
                p.tell(Component.translate("kubejs.message.respawn_protect.not_triggered"));
             }
        }
        return;
    }

    p.server.scheduleInTicks(1, () => {
        if (!p.isAlive() || !p.level) {
            return;
        }

        let 当前世界 = p.level;
        let 搜索框 = p.getBoundingBox().inflate(重生保护移除配置.半径);
        let 附近实体列表 = 当前世界.getEntitiesWithin(搜索框);
        let 已移除数量 = 0;

        for (let 实体 of 附近实体列表) {
            if (!实体 || !实体.isAlive() || 实体.equals(p) || 实体.isSpectator()) {
                continue;
            }

            let 实体ID = null;
            if (实体 && 实体.type !== undefined && 实体.type !== null) {
                let typeStr = String(实体.type);
                if (typeof typeStr === "string" && typeStr.includes(":")) {
                     实体ID = typeStr;
                }
            }
            
            if (typeof 实体ID !== "string") {
                continue;
            }

            if (重生保护移除配置.排除ID.indexOf(实体ID) !== -1) {
                continue;
            }

            if (重生保护移除配置.排除自定义名称 && 重生保护移除配置.排除自定义名称.length > 0) {
                let 实体自定义名称 = null;// 
                let 原始自定义名称 = 实体.customName; 

                if (原始自定义名称) { 
                    if (typeof 原始自定义名称.getString === "function") {
                        实体自定义名称 = 原始自定义名称.getString().trim(); 
                    } else if (typeof 原始自定义名称.string === "string") { 
                        实体自定义名称 = 原始自定义名称.string.trim();
                    } else if (typeof 原始自定义名称 === "string") { 
                        实体自定义名称 = 原始自定义名称.trim();
                    }
                }

                if (实体自定义名称 !== null && 实体自定义名称 !== "") { 
                    let 找到排除名称 = false;
                    for (let 排除名称 of 重生保护移除配置.排除自定义名称) {
                        if (实体自定义名称 === 排除名称) {
                            找到排除名称 = true;
                            break;
                        }
                    }
                    if (找到排除名称) {
                        continue;
                    }
                }
            }

            if (重生保护移除配置.仅限敌对) {
                if (!实体.isLiving()) {
                     continue;
                }
                let 是否敌对 = false;
                if (typeof 实体.isMonster === "function") {
                    是否敌对 = 实体.isMonster();
                } else if (typeof 实体.monster === "boolean") {
                    是否敌对 = 实体.monster;
                }

                if (!是否敌对) {
                    let 实体类型数据 = 实体.getType();
                    if (实体类型数据 && typeof 实体类型数据.getCategory === "function") {
                        let category = 实体类型数据.getCategory();
                        if (category && typeof category.getName === "function") {
                            if (category.getName() === "monster") {
                                是否敌对 = true;
                            }
                        } else if (category && category.toString().toLowerCase() === "monster") {
                             是否敌对 = true;
                        }
                    }
                }

                if (!是否敌对) {
                    continue;
                }
            }
            实体.discard();
            已移除数量++;
        }

        let 通知消息 = null;

        if (已移除数量 > 0) {
            let 实体类型文本 = 重生保护移除配置.仅限敌对 ? "敌对" : "";
            通知消息 = Component.translate("kubejs.message.respawn_protect.cleared", Text.of(p.name.string).gold(), 已移除数量, 实体类型文本);
        } else if (重生保护移除配置.无清除时是否通知玩家) {
            let 实体类型文本 = 重生保护移除配置.仅限敌对 ? "敌对生物" : "生物";
            通知消息 = Component.translate("kubejs.message.respawn_protect.none_found", 实体类型文本);
        }
        
        if (通知消息) {
            if (重生保护移除配置.通知全服) {
                p.server.tell(通知消息);
            } else {
                p.tell(通知消息);
            }
        }
    });
});